#! /bin/bash
#
#  This program will load a node stucture, previosly fetched with
#  program node_get.pl (or by manual FTP or FTP-tool), from workstation to RBS.
#  
#
#  Bjrn Toding	2002-01-29	First Release.
#  
#  ke Wensmark 2006-10-10      all "/tmp" replaced with "~". This is due to the problem that /tmp 
#                               is common to all users running on a metaframe and then the files 
#                               that are put there by one user can not be recreated by another.
#                               A check has also been added so that the user can see that all files 
#                               have been downloaded to the node correctly. 
#                               See TR: WRNad23569 and WRNad23553
#
#  ke Wensmark 2008-23-10      This script is totally remade. 
#
#  ke Wensmark 2011-12-14      All "~" replaced with "~/<pid>". This is due to the problem that if 
#                               one user is running this script many times simultaneously, as is the 
#                               case in the Continuous Integration System (CIS) environment. In CIS 
#                               the same user will run several test execution jobs in parallel and 
#                               this causes the ftp_out.cmd to be written to by several jobs at the 
#                               same time causing a corrupt file.  
#

# Check the arguments
IP=$1
USERNAME=$2
RBSPWD=$3

case $# in
     3)
         # Assume the directory is e.g: /proj/rbsiov/XXXXXX/tools
         directory=`pwd`      # get current working directory
         
         # Change the path to: /proj/rbsiov/XXXXXX/hard_disc
         directory=`echo $directory | sed s#tools#hard_disc#`
         ;;
         
     4)
         directory=$4
         ;;
         
     *)
         echo "Usage: $0 <Node IP adress> <rbs_user_name> <rbs_pwd> [path_to_dump_directory]"
         exit
         ;;
esac 

# Get the PID
PID=$$
echo "PID: $PID"

# Check that the directory to be scanned exists
if [ ! -d $directory ]
then
   echo "$directory directory not found - exiting"
   exit 0
fi 

# Make sure that the last caharacter is NOT a slash
directory=`echo $directory | sed s/$`

# Check if the node can be reached
#echo "Pinging $IP ..."

#status=`/usr/sbin/ping $IP`

# if ( ! echo "$status" | grep 'is alive' )
# then
    # echo "......exiting......"
    # exit
# fi

# Create the temporary directory
echo "mkdir ~/$PID"
mkdir ~/$PID

# Creat a temporary FTP-command file
echo "user $USERNAME $RBSPWD" > ~/$PID/ftp_put.cmd
echo "hash" >> ~/$PID/ftp_put.cmd
echo "bin" >> ~/$PID/ftp_put.cmd
echo "passive" >> ~/$PID/ftp_put.cmd

echo "============================================================="
echo "Scanning source directory:"
echo "   $directory"
echo "============================================================="

# First create all directories
echo "--- Scanning for Directories..."

for dir in $( find $directory -type d )   # -type d = directory
do

   # Remove the "root part" of the dir only keeping the hard disk path part
   new_dir=`echo $dir | sed s#$directory##`
   
   if [ "$new_dir" != "" ]
   then
      echo "mkdir $new_dir" >> ~/$PID/ftp_put.cmd
   fi
done


# Download all files
echo "--- Scanning for Files..."

for file in $( find $directory -type f )   # -type f = file
do

   # Remove the "root part" of the dir only keeping the hard disk path part
   new_file_path=`echo $file | sed s#$directory##`
   
   if [ "$new_file_path" != "" ]
   then
      echo "put $file $new_file_path" >> ~/$PID/ftp_put.cmd
   fi

done

echo "bye" >> ~/$PID/ftp_put.cmd

echo "ftp_put.cmd created"
echo ""


# Execute the command file
echo "--- Executing: ftp -n $IP < ~/$PID/ftp_put.cmd..."

/usr/bin/ftp -n $IP < ~/$PID/ftp_put.cmd | tee ~/$PID/ftp.log


# Checking if the download was successful
errorsFatal=`grep '^Not connected' ~/$PID/ftp.log`
errorsFatal2=`grep 'No such file or directory' ~/$PID/ftp.log`
errorsSevere=`grep '^[345]' ~/$PID/ftp.log | grep -v 'bytes' | grep -v 'File exists'`
errorsMinor=`grep '^[345]' ~/$PID/ftp.log | grep -v 'bytes'`

echo ""
echo ""
echo "============================================================="
echo "Verifying FTP session data making sure all files got there..."
echo "============================================================="
echo ""

if [ "$errorsFatal" != "" ]
then
  echo ""
  echo "============================================================="
  echo "FATAL ERROR"
  echo "============================================================="
  echo "These Fatal Errors were found during FTP session, please examine ~/$PID/ftp.log"
  grep '^Not connected' ~/$PID/ftp.log | grep -v 'bytes'
  exit 2
fi

if [ "$errorsFatal2" != "" ]
then
  echo ""
  echo "============================================================="
  echo "FATAL ERROR"
  echo "============================================================="
  echo "These Fatal Errors were found during FTP session, please examine ~/$PID/ftp.log"
  grep 'No such file or directory' ~/$PID/ftp.log 
  exit 3
fi


if [ "$errorsSevere" != "" ]
then
  echo ""
  echo "============================================================="
  echo "SEVERE ERROR"
  echo "============================================================="
  echo "These Severe Errors were found during FTP session, please examine ~/$PID/ftp.log"
  grep '^[345]' ~/$PID/ftp.log | grep -v 'bytes' | grep -v 'File exists' | grep -v 'File unavailable'
  exit 4
fi

#if ($#errorsMinor) then
#  echo "Minor errors found, these can be discarded if you are using ftp"
#  echo "towards a non formatted node. If the node was formatted prior to"
#  echo "running ftp_helper.sh please check the ~/$PID/ftp.log file."
#  exit 0;
#endif

# Removing temporary dir
\rm -R ~/$PID

echo "ALL FILES SUCCESSFULLY DOWNLOADED"
echo ""

exit 0
